/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.breakpoint.Watchpoint;

public class WatchDirective
extends AsmDirective {
    private List<ExprNode> exprList;

    public WatchDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.exprList = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        boolean bl;
        boolean bl2 = bl = this.exprList.isEmpty() || this.exprList.get(0) == null;
        if (bl) {
            evaluationState.diagnosticMgr.add(new AsmError("First argument must be present.", this.range));
            return this;
        }
        if (this.exprList.size() > 3) {
            evaluationState.diagnosticMgr.add(new AsmError(".watch takes max 3 arguments", this.range));
            return this;
        }
        for (ExprNode exprNode : this.exprList) {
            if (exprNode == null) continue;
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = false;
        Value value = this.exprList.get(0).evaluate(evaluationState);
        bl |= value.isInvalid();
        Value value2 = null;
        if (this.hasArg(1, this.exprList)) {
            value2 = this.exprList.get(1).evaluate(evaluationState);
            bl |= value2.isInvalid();
        }
        Value value3 = null;
        if (this.hasArg(2, this.exprList)) {
            value3 = this.exprList.get(2).evaluate(evaluationState);
            bl |= value3.isInvalid();
        }
        if (bl) {
            return this;
        }
        Watchpoint watchpoint = new Watchpoint();
        watchpoint.segment = evaluationState.segmentMgr.getCurrentSegment();
        watchpoint.address1 = value.getInt(this.range);
        watchpoint.address2 = value2 == null ? null : Integer.valueOf(value2.getInt(this.range));
        watchpoint.argument = value3 == null ? null : value3.getString(this.range);
        evaluationState.breakpointMgr.addWatchpoint(watchpoint);
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    private boolean hasArg(int n, List<ExprNode> list) {
        return list.size() > n && list.get(n) != null;
    }

    @Override
    public String toString() {
        return "Watch";
    }
}

